// File_Mk - Info for Matroska files
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Info for Matroska files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
// Compilation condition
#if defined(MEDIAINFO_MK_YES) || (!(defined(MEDIAINFO_VIDEO_NO) && defined(MEDIAINFO_AUDIO_NO)) && !defined(MEDIAINFO_MK_NO))
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// libebml includes
#ifdef _WIN32
	#include <ebml/WinIOCallback.h>
#else
	#include <ebml/StdIOCallback.h>
#endif
#include <ebml/EbmlTypes.h>
#include <ebml/EbmlHead.h>
#include <ebml/EbmlVoid.h>
#include <ebml/EbmlCrc32.h>
#include <ebml/EbmlSubHead.h>
#include <ebml/EbmlStream.h>
#include <ebml/EbmlBinary.h>
#include <ebml/EbmlString.h>
#include <ebml/EbmlUnicodeString.h>
#include <ebml/EbmlContexts.h>
#include <ebml/EbmlVersion.h>

// libmatroska includes
#include <matroska/KaxConfig.h>
#include <matroska/KaxBlock.h>
#include <matroska/KaxSegment.h>
#include <matroska/KaxContexts.h>
#include <matroska/KaxChapters.h>
#include <matroska/KaxSeekHead.h>
#include <matroska/KaxTracks.h>
#include <matroska/KaxInfo.h>
#include <matroska/KaxInfoData.h>
#include <matroska/KaxTags.h>
#include <matroska/KaxTag.h>
#include <matroska/KaxTagMulti.h>
#include <matroska/KaxCluster.h>
#include <matroska/KaxClusterData.h>
#include <matroska/KaxTrackAudio.h>
#include <matroska/KaxTrackVideo.h>
#include <matroska/KaxAttachments.h>
#include <matroska/KaxAttached.h>
#include <matroska/KaxVersion.h>

#include <ZenLib/Utils.h>
#include "MediaInfo/Multiple/File_Mk.h"
using namespace ZenLib;
using namespace libebml;
using namespace libmatroska;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//---------------------------------------------------------------------------
//To clarify the code
#define BEGIN \
UpperElementLevel=0; \
Level++; \
ElementLevel[Level]=Stream.FindNextElement(ElementLevel[Level-1]->Generic().Context, UpperElementLevel, All, 0); \
while (!ShouldStop && ElementLevel[Level]!=NULL && UpperElementLevel<=0 && File.getFilePointer()<ElementLevel[Level-1]->GetElementPosition()+ElementLevel[Level-1]->HeadSize()+ElementLevel[Level-1]->GetSize()) \
{ \
        if(0){

//-For each Ebml Atom (and this is a value, not an atom with other atoms in it)
#define EBML(_KAX) \
    } \
    else if (EbmlId(*ElementLevel[Level])==E##_KAX::ClassInfos.GlobalId) \
    { \
        E##_KAX* Kax=static_cast<E##_KAX*>(ElementLevel[Level]); \
        Kax->ReadData(Stream.I_O());

//-For each Matroska Atom (and this is a value, not an atom with other atoms in it)
#define KAX(_KAX) \
    } \
    else if (EbmlId(*ElementLevel[Level])==Kax##_KAX::ClassInfos.GlobalId) \
    { \
        Kax##_KAX* Kax=static_cast<Kax##_KAX*>(ElementLevel[Level]); \
        Kax->ReadData(Stream.I_O());

//-For each Matroska Atom (and this is an Atom with other atoms in it, not a value)
#define SUB(_KAX) \
    } \
    else if (EbmlId(*ElementLevel[Level])==Kax##_KAX::ClassInfos.GlobalId) \
    {

//-End to find an atom
#define END \
    } \
    if (UpperElementLevel>0) \
    { \
        delete ElementLevel[Level]; \
        ElementLevel[Level]=ElementLevel[Level+1]; \
        UpperElementLevel--; \
    } \
    else \
    { \
        ElementLevel[Level]->SkipData(Stream, ElementLevel[Level]->Generic().Context); \
        delete ElementLevel[Level]; ElementLevel[Level]=NULL; \
        if (!ShouldStop && File.getFilePointer()<ElementLevel[Level-1]->GetElementPosition()+ElementLevel[Level-1]->HeadSize()+ElementLevel[Level-1]->GetSize()) \
            ElementLevel[Level]=Stream.FindNextElement(ElementLevel[Level-1]->Generic().Context, UpperElementLevel, (intu)-1, 0); \
    } \
} \
Level--;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
typedef struct //Microsoft Video structure (video codec private)
{
   int32s  Size;
   int32s  Width;
   int32s  Height;
   int16u  Planes;
   int16u  BitCount;
   int32u  Compression;
   int32u  SizeImage;
   int32s  XPelsPerMeter;
   int32s  YPelsPerMeter;
   int32u  ClrUsed;
   int32u  ClrImportant;
} Mk_VideoInfo_MS;

typedef struct //Microsoft Audio structure (audio codec private)
{
    int16u FormatTag;
    int16u Channels;
    int32u SamplesPerSec;
    int32u AvgBytesPerSec;
    int16u BlockAlign;
    int16u BitsPerSample;
    int16u Size;
} Mk_AudioInfo_MS;
//---------------------------------------------------------------------------

//***************************************************************************
// Functions
//***************************************************************************

int File_Mk::Read()
{
    EbmlElement* ElementLevel[9]; //Must be here because we need of them in catch(...)

    try {

    #ifdef _WIN32
        WinIOCallback File(CompleteFileName.c_str(), MODE_READ);
    #else
        if (wxConvCurrent->cWX2MB(CompleteFileName.c_str()).data()==NULL)
            return -1;
        StdIOCallback File(wxConvCurrent->cWX2MB(CompleteFileName.c_str()), MODE_READ); //TODO : Unicode FileName
    #endif
	EbmlStream Stream(File);

	bool ShouldStop=false;
    int Level=0;
    int UpperElementLevel=0;
	int64u TimecodeScale=1000000;
    for (size_t Pos=0; Pos<9; Pos++) ElementLevel[Pos]=NULL;

    //Test if the file is Matroska
    bool IsMatroska=false;
	ElementLevel[0]=Stream.FindNextID(EbmlHead::ClassInfos, All);
    if (ElementLevel[0] && EbmlId(*ElementLevel[0])==EbmlHead::ClassInfos.GlobalId && File.getFilePointer()<ElementLevel[0]->GetElementPosition()+ElementLevel[0]->HeadSize()+ElementLevel[0]->GetSize())
    {
        BEGIN
        EBML(DocType)
            if (std::string(*Kax)=="matroska")
                IsMatroska=true;
        END
    }
    if (ElementLevel[0])
    {
        ElementLevel[0]->SkipData(Stream, EbmlHead_Context);
        delete ElementLevel[0]; ElementLevel[0]=NULL;
    }

    if (!IsMatroska)
        return -1;

    Stream_Prepare(Stream_General);
    General[0](_T("Format"))=_T("Matroska");
    General[0](_T("Format/String"))=_T("Matroska");
    General[0](_T("Format/Url"))=_T("http://www.matroska.org");
    General[0](_T("Format/Extensions"))=_T("MKV MKA MKS");

	//Segment
    ElementLevel[0]=Stream.FindNextID(KaxSegment::ClassInfos, (intu)-1);
    if (EbmlId(*ElementLevel[0])==KaxSegment::ClassInfos.GlobalId)
    {
        BEGIN
        SUB(Info)
            BEGIN
            KAX(TimecodeScale)
                TimecodeScale=uint64(*Kax);
            KAX(Duration)
                General[0](_T("PlayTime")).From_Number(double(*Kax)* int64u_float64(TimecodeScale) / 1000000.0);
            KAX(DateUTC)
                General[0](_T("Encoded_Date")).From_Number(Kax->GetEpochDate());
            KAX(Title)
                General[0](_T("Title")).From_Unicode(UTFstring(*Kax).c_str());
            KAX(MuxingApp)
                General[0](_T("Encoded_Library")).From_Unicode(UTFstring(*Kax).c_str());
            KAX(WritingApp)
                General[0](_T("Encoded_Application")).From_Unicode(UTFstring(*Kax).c_str());
            END
        SUB(Cluster)
            ShouldStop=true;
        SUB(Tracks)
            BEGIN
            SUB(TrackEntry)
                ZtringListList Track_Temp;
                ZtringListList* Track_Current=NULL;
                uint8 TrackType=0;
                uint32 TrackDefaultDuration=0;
                BEGIN
                KAX(TrackNumber)
                    Track_Temp(_T("ID")).From_Number((uint32)(*Kax));
                KAX(TrackUID)
                    Track_Temp(_T("UniqueID")).From_Number((uint32)(*Kax));
                KAX(TrackType)
                    TrackType=uint8(*Kax);
                    switch(TrackType)
                    {
                        case track_video:    Track_Current=&Video[Stream_Prepare(Stream_Video)]; break;
                        case track_audio:    Track_Current=&Audio[Stream_Prepare(Stream_Audio)]; break;
                        case track_subtitle: Track_Current=&Text [Stream_Prepare(Stream_Text )]; break;
                        default:             Track_Current=NULL;
                    }
                KAX(TrackDefaultDuration)
                    TrackDefaultDuration=(uint32)(*Kax);
                KAX(TrackName)
                    Track_Temp(_T("Title"))=UTFstring(*Kax).c_str();
                KAX(TrackLanguage)
                    Track_Temp(_T("Language")).From_Local(std::string(*Kax).c_str());
                KAX(CodecID)
                    Track_Temp(_T("Codec")).From_Local(std::string(*Kax).c_str());
                KAX(CodecPrivate)
                    //MS Windows video codecs are in private element of codec
                         if (Track_Temp(_T("Codec"))==_T("V_MS/VFW/FOURCC"))
                    {
                        Mk_VideoInfo_MS *VideoInfo=(Mk_VideoInfo_MS*)Kax->GetBuffer();
                        Track_Temp(_T("Codec")).From_Local((char*)&(VideoInfo->Compression), 0, 4);
                        Track_Temp(_T("Width")).From_Number(VideoInfo->Width);
                        Track_Temp(_T("Height")).From_Number(VideoInfo->Height);
                        Track_Temp(_T("Resolution")).From_Number(VideoInfo->BitCount);
                    }
                    //MS Windows audio codecs are in private element of codec
                    else if (Track_Temp(_T("Codec"))==_T("A_MS/ACM"))
                    {
                        Mk_AudioInfo_MS *AudioInfo=(Mk_AudioInfo_MS*)Kax->GetBuffer();
                        Track_Temp(_T("Codec")).From_Number(AudioInfo->FormatTag, 16);
                    }
                KAX(CodecName)
                    Track_Temp(_T("Codec/String"))=UTFstring(*Kax).c_str();
                SUB(TrackVideo)
                    BEGIN
                    KAX(VideoPixelWidth)
                        Track_Temp(_T("Width")).From_Number((uint16)(*Kax));
                    KAX(VideoPixelHeight)
                        Track_Temp(_T("Height")).From_Number((uint16)(*Kax));
                    KAX(VideoFrameRate)
                        Track_Temp(_T("FrameRate")).From_Number((double)(*Kax), 3);
                    END
                SUB(TrackAudio)
                    BEGIN
                    KAX(AudioSamplingFreq)
                        Track_Temp(_T("SamplingRate")).From_Number((double)(*Kax), 0);
                    KAX(AudioOutputSamplingFreq)
                        Track_Temp(_T("SamplingRate")).From_Number((double)(*Kax), 0);
                    KAX(AudioChannels)
                        Track_Temp(_T("Channel(s)")).From_Number((uint16)(*Kax));
                    KAX(AudioBitDepth)
                        Track_Temp(_T("Resolution")).From_Number((uint16)(*Kax));
                    END
                END
                //Fill track_Current with temporary track which contains info before we know which kind of track it is...
                if (Track_Current)
                {
                    for (size_t Pos=0; Pos<Track_Temp.size(); Pos++)
                        (*Track_Current)(Track_Temp(Pos, 0), 1)=Track_Temp(Pos, 1);
                    if (TrackDefaultDuration && TrackType==track_video)
                        (*Track_Current)(_T("FrameRate")).From_Number(((float)1)/TrackDefaultDuration*1000000000);
                }
            END
        SUB(Cues)
        SUB(Attachments)
            BEGIN
            SUB(Attached)
                General[0](_T("Cover"))=_T("Y");
                BEGIN
                KAX(FileDescription)
                    General[0](_T("Cover"))=UTFstring(*Kax).c_str();
                END
            END
        SUB(Chapters)
            BEGIN
            SUB(EditionEntry)
                size_t Chapters_Pos=Stream_Prepare(Stream_Chapters);
                size_t Pos=0;
                BEGIN
                KAX(EditionUID)
                    Chapters[Chapters_Pos](_T("UniqueID")).From_Number((uint32)(*Kax));
                SUB(ChapterAtom)
                    Pos++;
                    BEGIN
                    SUB(ChapterDisplay)
                        BEGIN
                        KAX(ChapterString)
                            Chapters[Chapters_Pos](Ztring::ToZtring(Pos))=UTFstring(*Kax).c_str();
                        END
                    END
                END
            END
        SUB(Tags)
            BEGIN
            SUB(Tag)
                BEGIN
                SUB(TagSimple)
                    Ztring Name=_T("XXX");
                    BEGIN
                    KAX(TagName)
                        Name=UTFstring(*Kax).c_str();
                    KAX(TagString)
                        General[0](Name)=UTFstring(*Kax).c_str();
                    END
                END
            END
        END
    }
    //TODO : if multiple segments
    delete ElementLevel[0]; ElementLevel[0]=NULL;

    return 1;

    }
    catch (...)
    {
        for (size_t Pos=0; Pos<9; Pos++)
            delete ElementLevel[Pos];
        return -1;
    }
}

//---------------------------------------------------------------------------
void File_Mk::HowTo(stream_t StreamKind)
{
         if (StreamKind==Stream_General)
    {
        General[0](_T("Format"), Info_HowTo)=_T("R");
        General[0](_T("OveralBitRate"), Info_HowTo)=_T("R");
        General[0](_T("PlayTime"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Video)
    {
        Video[0](_T("Codec"), Info_HowTo)=_T("R");
        Video[0](_T("BitRate"), Info_HowTo)=_T("R");
        Video[0](_T("Width"), Info_HowTo)=_T("R");
        Video[0](_T("Height"), Info_HowTo)=_T("R");
        Video[0](_T("AspectRatio"), Info_HowTo)=_T("R");
        Video[0](_T("FrameRate"), Info_HowTo)=_T("R");
    }
    else if (StreamKind==Stream_Audio)
    {
        Audio[0](_T("Codec"), Info_HowTo)=_T("R");
        Audio[0](_T("BitRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Channels"), Info_HowTo)=_T("R");
        Audio[0](_T("SamplingRate"), Info_HowTo)=_T("R");
        Audio[0](_T("Resolution"), Info_HowTo)=_T("R");
    }
}

} //NameSpace

#endif //MEDIAINFO_MK_*






















